<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Console\Events\CommandStarting;
use Illuminate\Support\Facades\Event;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        Event::listen(CommandStarting::class, function (CommandStarting $event) {
            if ((dbConnectionStatus() && Schema::hasTable('users') && file_exists(storage_path('installed')))) {
                if (in_array($event->command, ['migrate:fresh', 'db:wipe', 'db:seed'])) {
                    throw new \Exception("❌ Command '{$event->command}' is blocked in production.");
                }
            }
        });
    }
}

